
#include "fh.h"
#include "combat.h"


extern struct species_data	*c_species[MAX_SPECIES];


regenerate_shields (act)

struct action_data	*act;

{
    int			i, species_index, unit_index;

    long		ls, max_shield_strength, percent;

    struct ship_data	*sh;


    /* Shields are regenerated by 5 + LS/10 percent per round. */
    for (unit_index = 0; unit_index < act->num_units_fighting; unit_index++)
    {
	species_index = act->fighting_species_index[unit_index];
	ls = c_species[species_index]->tech_level[LS];
	max_shield_strength = act->shield_strength[unit_index];

	percent = (ls/10L) + 5L;
	act->shield_strength_left[unit_index] +=
		(percent * max_shield_strength) / 100L;
	if (act->shield_strength_left[unit_index] > max_shield_strength)
	    act->shield_strength_left[unit_index] = max_shield_strength;
    }
}
